import type { ComponentType, ReactElement } from 'react';
import type { AbstractCalculator, CSSInterpolation } from '@ant-design/cssinjs';
import type { AliasToken, ComponentTokenMap, GlobalToken, OverrideToken, UseComponentStyleResult } from '../interface';
export type OverrideTokenWithoutDerivative = ComponentTokenMap;
export type OverrideComponent = keyof OverrideTokenWithoutDerivative;
export type GlobalTokenWithComponent<C extends OverrideComponent> = GlobalToken & ComponentTokenMap[C];
type ComponentToken<C extends OverrideComponent> = Exclude<OverrideToken[C], undefined>;
type ComponentTokenKey<C extends OverrideComponent> = keyof ComponentToken<C>;
export interface StyleInfo {
    hashId: string;
    prefixCls: string;
    rootPrefixCls: string;
    iconPrefixCls: string;
}
export type CSSUtil = {
    calc: (number: any) => AbstractCalculator;
    max: (...values: (number | string)[]) => number | string;
    min: (...values: (number | string)[]) => number | string;
};
export type TokenWithCommonCls<T> = T & {
    /** Wrap component class with `.` prefix */
    componentCls: string;
    /** Origin prefix which do not have `.` prefix */
    prefixCls: string;
    /** Wrap icon class with `.` prefix */
    iconCls: string;
    /** Wrap ant prefixCls class with `.` prefix */
    antCls: string;
} & CSSUtil;
export type FullToken<C extends OverrideComponent> = TokenWithCommonCls<GlobalTokenWithComponent<C>>;
export type GenStyleFn<C extends OverrideComponent> = (token: FullToken<C>, info: StyleInfo) => CSSInterpolation;
export type GetDefaultToken<C extends OverrideComponent> = null | OverrideTokenWithoutDerivative[C] | ((token: AliasToken & Partial<OverrideTokenWithoutDerivative[C]>) => OverrideTokenWithoutDerivative[C]);
export default function genComponentStyleHook<C extends OverrideComponent>(componentName: C | [C, string], styleFn: GenStyleFn<C>, getDefaultToken?: GetDefaultToken<C>, options?: {
    resetStyle?: boolean;
    resetFont?: boolean;
    deprecatedTokens?: [ComponentTokenKey<C>, ComponentTokenKey<C>][];
    /**
     * Only use component style in client side. Ignore in SSR.
     */
    clientOnly?: boolean;
    /**
     * Set order of component style. Default is -999.
     */
    order?: number;
    injectStyle?: boolean;
    unitless?: {
        [key in ComponentTokenKey<C>]: boolean;
    };
}): (prefixCls: string, rootCls?: string) => UseComponentStyleResult;
export interface SubStyleComponentProps {
    prefixCls: string;
    rootCls?: string;
}
type RestParameters<T extends any[]> = T extends [any, ...infer Rest] ? Rest : never;
export declare const genSubStyleComponent: <C extends OverrideComponent>(componentName: [C, string], ...args: RestParameters<Parameters<typeof genComponentStyleHook<C>>>) => ComponentType<SubStyleComponentProps>;
export type CSSVarRegisterProps = {
    rootCls: string;
    component: string;
    cssVar: {
        prefix?: string;
        key?: string;
    };
};
export declare const genStyleHooks: <C extends OverrideComponent>(component: C | [C, string], styleFn: GenStyleFn<C>, getDefaultToken?: GetDefaultToken<C>, options?: {
    resetStyle?: boolean;
    resetFont?: boolean;
    deprecatedTokens?: [ComponentTokenKey<C>, ComponentTokenKey<C>][];
    /**
     * Component tokens that do not need unit.
     */
    unitless?: { [key in ComponentTokenKey<C>]: boolean; };
    /**
     * Only use component style in client side. Ignore in SSR.
     */
    clientOnly?: boolean;
    /**
     * Set order of component style.
     * @default -999
     */
    order?: number;
    /**
     * Whether generate styles
     * @default true
     */
    injectStyle?: boolean;
}) => (prefixCls: string, rootCls?: string) => readonly [(node: ReactElement) => ReactElement, string, string | undefined];
export {};
