import { BrowserRouter, Routes, Route, Navigate } from "react-router-dom";
import LoginPage from "./pages/Login";
import RegisterPage from "./pages/Register";
import ForgotPasswordPage from "./pages/ForgotPassword";
import AppLayout from "./layout/AppLayout";
import Dashboard from "./pages/Dashboard";
import ProfilePage from "./pages/Profile";
import CreditsPage from "./pages/Credits";
import DebitsPage from "./pages/Debits";
import RequestsPage from "./pages/Requests";
import RequestsViewPage from "./pages/RequestsView";
import ReportsPage from "./pages/Reports";
import NotificationsPage from "./pages/Notifications";
import SettingsPage from "./pages/Settings";
import UsersAdminPage from "./pages/admin/Users";
import MembersAdminPage from "./pages/admin/Members";
import CashiersAdminPage from "./pages/admin/Cashiers";
import SavingsPlanTypesAdminPage from "./pages/admin/SavingsPlanTypes";
import CharityTypesAdminPage from "./pages/admin/CharityTypes";
import LoanRequestsAdminPage from "./pages/admin/LoanRequests";
import CharityRequestsAdminPage from "./pages/admin/CharityRequests";
import ReleaseRequestsAdminPage from "./pages/admin/ReleaseRequests";
import ActivityAdminPage from "./pages/admin/Activity";
import ExcelAdminPage from "./pages/admin/Excel";
import AdminOverviewPage from "./pages/admin/Overview";
import MemberSavingsAdminPage from "./pages/admin/MemberSavings";
import CashierAnalysisAdminPage from "./pages/admin/CashierAnalysis";
import ProtectedRoute from "./components/ProtectedRoute";
import RoleRoute from "./components/RoleRoute";
import PermissionRoute from "./components/PermissionRoute";

const App = () => {
  return (
    <BrowserRouter>
      <Routes>
        <Route path="/" element={<Navigate to="/login" replace />} />
        <Route path="/login" element={<LoginPage />} />
        <Route path="/register" element={<RegisterPage />} />
        <Route path="/forgot-password" element={<ForgotPasswordPage />} />

        <Route
          path="/app"
          element={
            <ProtectedRoute>
              <AppLayout />
            </ProtectedRoute>
          }
        >
          <Route
            path="home"
            element={
              <PermissionRoute permission="home.view">
                <Dashboard />
              </PermissionRoute>
            }
          />
          <Route
            path="profile"
            element={
              <PermissionRoute permission="profile.view">
                <ProfilePage />
              </PermissionRoute>
            }
          />
          <Route
            path="credits"
            element={
              <PermissionRoute permission="credits.view">
                <CreditsPage />
              </PermissionRoute>
            }
          />
          <Route
            path="debits"
            element={
              <PermissionRoute permission="debits.view">
                <DebitsPage />
              </PermissionRoute>
            }
          />
          <Route path="requests" element={<RequestsPage />} />
          <Route
            path="requests-view"
            element={
              <PermissionRoute permission="requests.view_all">
                <RequestsViewPage />
              </PermissionRoute>
            }
          />
          <Route
            path="reports"
            element={
              <PermissionRoute permission="reports.view">
                <ReportsPage />
              </PermissionRoute>
            }
          />
          <Route
            path="notifications"
            element={
              <PermissionRoute permission="notifications.view">
                <NotificationsPage />
              </PermissionRoute>
            }
          />
          <Route
            path="settings"
            element={
              <PermissionRoute permission="settings.view">
                <SettingsPage />
              </PermissionRoute>
            }
          />

          <Route
            path="admin/overview"
            element={
              <RoleRoute roles={["administrator", "editor"]}>
                <AdminOverviewPage />
              </RoleRoute>
            }
          />
          <Route
            path="admin/member-savings"
            element={
              <RoleRoute roles={["administrator", "editor"]}>
                <MemberSavingsAdminPage />
              </RoleRoute>
            }
          />
          <Route
            path="admin/cashier-analysis"
            element={
              <RoleRoute roles={["administrator", "editor"]}>
                <CashierAnalysisAdminPage />
              </RoleRoute>
            }
          />

          <Route
            path="admin/users"
            element={
              <RoleRoute roles={["administrator"]}>
                <UsersAdminPage />
              </RoleRoute>
            }
          />
          <Route
            path="admin/members"
            element={
              <RoleRoute roles={["administrator"]}>
                <MembersAdminPage />
              </RoleRoute>
            }
          />
          <Route
            path="admin/cashiers"
            element={
              <RoleRoute roles={["administrator"]}>
                <CashiersAdminPage />
              </RoleRoute>
            }
          />
          <Route
            path="admin/savings-plan-types"
            element={
              <RoleRoute roles={["administrator"]}>
                <SavingsPlanTypesAdminPage />
              </RoleRoute>
            }
          />
          <Route
            path="admin/charity-types"
            element={
              <RoleRoute roles={["administrator"]}>
                <CharityTypesAdminPage />
              </RoleRoute>
            }
          />
          <Route
            path="admin/loan-requests"
            element={
              <RoleRoute roles={["administrator"]}>
                <LoanRequestsAdminPage />
              </RoleRoute>
            }
          />
          <Route
            path="admin/charity-requests"
            element={
              <RoleRoute roles={["administrator"]}>
                <CharityRequestsAdminPage />
              </RoleRoute>
            }
          />
          <Route
            path="admin/release-requests"
            element={
              <RoleRoute roles={["administrator"]}>
                <ReleaseRequestsAdminPage />
              </RoleRoute>
            }
          />
          <Route
            path="admin/activity"
            element={
              <RoleRoute roles={["administrator"]}>
                <ActivityAdminPage />
              </RoleRoute>
            }
          />
          <Route
            path="admin/excel"
            element={
              <RoleRoute roles={["administrator"]}>
                <ExcelAdminPage />
              </RoleRoute>
            }
          />
        </Route>
      </Routes>
    </BrowserRouter>
  );
};

export default App;
