import axios from "axios";

const api = axios.create({
  baseURL: import.meta.env.VITE_API_BASE_URL || "http://localhost:5000/api/v1",
  withCredentials: true
});

const getCookie = (name: string) => {
  const value = `; ${document.cookie}`;
  const parts = value.split(`; ${name}=`);
  if (parts.length === 2) {
    return parts.pop()?.split(";").shift();
  }
  return undefined;
};

api.interceptors.request.use((config) => {
  const csrf = getCookie("csrf_access_token");
  if (csrf) {
    config.headers["X-CSRF-TOKEN"] = csrf;
  }
  return config;
});

export default api;
