import { Tooltip } from "antd";
import { getApiOrigin } from "../utils/apiOrigin";

const badgeFileForPlan = (planTypeName?: string | null): string | null => {
  if (!planTypeName) return null;
  const key = planTypeName.toLowerCase();
  const known = ["bronze", "silver", "gold", "platinum", "titanium"];
  const match = known.find((k) => key.includes(k));
  return match ? `${match}.png` : null;
};

export const getPlanBadgeUrl = (planTypeName?: string | null): string | null => {
  const file = badgeFileForPlan(planTypeName);
  if (!file) return null;
  return `${getApiOrigin()}/static/badges/${file}`;
};

const PlanBadge = ({
  planTypeName,
  size = 22,
  showTooltip = true
}: {
  planTypeName?: string | null;
  size?: number;
  showTooltip?: boolean;
}) => {
  const url = getPlanBadgeUrl(planTypeName);
  if (!url) return null;

  const img = (
    <img
      src={url}
      alt={`${planTypeName || "Plan"} badge`}
      width={size}
      height={size}
      style={{ objectFit: "contain", display: "inline-block" }}
    />
  );

  if (!showTooltip) return img;
  return <Tooltip title={planTypeName}>{img}</Tooltip>;
};

export default PlanBadge;

