import { useState } from "react";
import { Button, Card, Form, Input, Typography, Alert } from "antd";
import { Link } from "react-router-dom";
import api from "../api/client";

const { Title, Text } = Typography;

const ForgotPasswordPage = () => {
  const [message, setMessage] = useState<string | null>(null);
  const [error, setError] = useState<string | null>(null);

  const onFinish = async (values: { email: string }) => {
    setError(null);
    setMessage(null);
    try {
      const response = await api.post("/auth/forgot-password", values);
      setMessage(response.data.message || "Check your email for the new password.");
    } catch (err: any) {
      setError(err?.response?.data?.message || "Request failed");
    }
  };

  return (
    <div style={{ minHeight: "100vh", display: "grid", placeItems: "center" }}>
      <Card className="panel" style={{ width: 380 }}>
        <Title level={3}>Reset Password</Title>
        <Text type="secondary">We will email a new password to you.</Text>
        {message && <Alert style={{ marginTop: 12 }} type="success" message={message} />}
        {error && <Alert style={{ marginTop: 12 }} type="error" message={error} />}
        <Form layout="vertical" onFinish={onFinish} style={{ marginTop: 20 }}>
          <Form.Item name="email" label="Email" rules={[{ required: true, type: "email" }]}>
            <Input placeholder="Email" />
          </Form.Item>
          <Button type="primary" htmlType="submit" block>
            Send Reset
          </Button>
        </Form>
        <div style={{ marginTop: 16 }}>
          <Link to="/login">Back to login</Link>
        </div>
      </Card>
    </div>
  );
};

export default ForgotPasswordPage;
