import { useState } from "react";
import { Button, Card, Form, Input, Typography, Alert } from "antd";
import { useNavigate, Link } from "react-router-dom";
import api from "../api/client";
import { useAuthStore } from "../store/authStore";

const { Title, Text } = Typography;

const LoginPage = () => {
  const [error, setError] = useState<string | null>(null);
  const navigate = useNavigate();
  const setUser = useAuthStore((state) => state.setUser);

  const onFinish = async (values: { username: string; password: string }) => {
    setError(null);
    try {
      const response = await api.post("/auth/login", values);
      setUser(response.data.data);
      navigate("/app/home");
    } catch (err: any) {
      setError(err?.response?.data?.message || "Login failed");
    }
  };

  return (
    <div style={{ minHeight: "100vh", display: "grid", placeItems: "center" }}>
      <Card className="panel glow" style={{ width: 380 }}>
        <Title level={3}>Welcome Back</Title>
        <Text type="secondary">Sign in to your ERP workspace.</Text>
        {error && <Alert style={{ marginTop: 12 }} type="error" message={error} />}
        <Form layout="vertical" onFinish={onFinish} style={{ marginTop: 20 }}>
          <Form.Item name="username" label="Username or Email" rules={[{ required: true }]}>
            <Input placeholder="username or email" />
          </Form.Item>
          <Form.Item name="password" label="Password" rules={[{ required: true }]}>
            <Input.Password placeholder="????????" />
          </Form.Item>
          <Button type="primary" htmlType="submit" block>
            Sign In
          </Button>
        </Form>
        <div style={{ marginTop: 16, display: "flex", justifyContent: "space-between" }}>
          <Link to="/forgot-password">Forgot password?</Link>
          <Link to="/register">Create account</Link>
        </div>
      </Card>
    </div>
  );
};

export default LoginPage;
