import { useState } from "react";
import { Button, Card, Form, Input, Typography, Alert } from "antd";
import { Link } from "react-router-dom";
import api from "../api/client";

const { Title, Text } = Typography;

const RegisterPage = () => {
  const [message, setMessage] = useState<string | null>(null);
  const [error, setError] = useState<string | null>(null);

  const onFinish = async (values: any) => {
    setError(null);
    setMessage(null);
    try {
      await api.post("/auth/register", values);
      setMessage("Registration successful. Please wait for approval.");
    } catch (err: any) {
      setError(err?.response?.data?.message || "Registration failed");
    }
  };

  return (
    <div style={{ minHeight: "100vh", display: "grid", placeItems: "center" }}>
      <Card className="panel" style={{ width: 420 }}>
        <Title level={3}>Create Account</Title>
        <Text type="secondary">Join the Jana savings community.</Text>
        {message && <Alert style={{ marginTop: 12 }} type="success" message={message} />}
        {error && <Alert style={{ marginTop: 12 }} type="error" message={error} />}
        <Form layout="vertical" onFinish={onFinish} style={{ marginTop: 20 }}>
          <Form.Item name="full_name" label="Full Name" rules={[{ required: true }]}>
            <Input placeholder="Full name" />
          </Form.Item>
          <Form.Item name="username" label="Username" rules={[{ required: true }]}>
            <Input placeholder="Username" />
          </Form.Item>
          <Form.Item name="email" label="Email" rules={[{ required: true, type: "email" }]}>
            <Input placeholder="Email" />
          </Form.Item>
          <Form.Item name="mobile_number" label="Mobile Number" rules={[{ required: true }]}>
            <Input placeholder="+91" />
          </Form.Item>
          <Form.Item name="password" label="Password" rules={[{ required: true }]}>
            <Input.Password placeholder="Create password" />
          </Form.Item>
          <Button type="primary" htmlType="submit" block>
            Register
          </Button>
        </Form>
        <div style={{ marginTop: 16 }}>
          <Link to="/login">Back to login</Link>
        </div>
      </Card>
    </div>
  );
};

export default RegisterPage;
