import { create } from "zustand";

export type ThemeMode = "dark" | "light";

interface ThemeState {
  mode: ThemeMode;
  toggle: () => void;
  setMode: (mode: ThemeMode) => void;
}

const getInitialMode = (): ThemeMode => {
  const stored = localStorage.getItem("app_theme");
  return stored === "light" ? "light" : "dark";
};

export const useThemeStore = create<ThemeState>((set) => ({
  mode: getInitialMode(),
  toggle: () =>
    set((state) => {
      const next = state.mode === "dark" ? "light" : "dark";
      localStorage.setItem("app_theme", next);
      return { mode: next };
    }),
  setMode: (mode) => {
    localStorage.setItem("app_theme", mode);
    set({ mode });
  }
}));
